//+------------------------------------------------------------------+
//|                                     Fractals - adjustable period |
//+------------------------------------------------------------------+
#property link      "www.forex-station.com"
#property copyright "www.forex-station.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1  DeepSkyBlue
#property indicator_color2  PaleVioletRed
#property indicator_color3  DeepSkyBlue
#property indicator_color4  PaleVioletRed
#property indicator_color5  DeepSkyBlue
#property indicator_color6  PaleVioletRed
#property indicator_color7  DeepSkyBlue
#property indicator_color8  PaleVioletRed
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  3
#property indicator_width4  3
#property indicator_width5  4
#property indicator_width6  4
#property indicator_width7  5
#property indicator_width8  5

//
//
//
//
//

extern string                TimeFrame1              = "Current time frame";
extern string                TimeFrame2              = "next1";
extern string                TimeFrame3              = "next2";
extern string                TimeFrame4              = "next3";
extern int                   FractalPeriod           = 25;
extern ENUM_APPLIED_PRICE    PriceHigh               = PRICE_HIGH;
extern ENUM_APPLIED_PRICE    PriceLow                = PRICE_LOW;
extern double                UpperArrowDisplacement1 = 0.2;
extern double                LowerArrowDisplacement1 = 0.2;
extern double                UpperArrowDisplacement2 = 0.3;
extern double                LowerArrowDisplacement2 = 0.3;
extern double                UpperArrowDisplacement3 = 0.4;
extern double                LowerArrowDisplacement3 = 0.4;
extern double                UpperArrowDisplacement4 = 0.5;
extern double                LowerArrowDisplacement4 = 0.5;
extern bool                  alertsOn                = false;
extern bool                  alertsMessage           = true;
extern bool                  alertsSound             = false;
extern bool                  alertsEmail             = false;
extern bool                  alertsNotify            = false;

//
//
//
//
//

double UpperBuffer[];
double LowerBuffer[];
double UpperBuffer1[];
double LowerBuffer1[];
double UpperBuffer2[];
double LowerBuffer2[];
double UpperBuffer3[];
double LowerBuffer3[];

int    timeFrames[4];
bool   returnBars;
bool   calculateValue;
string indicatorFileName;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,UpperBuffer);  SetIndexStyle(0,DRAW_ARROW); SetIndexArrow(0,159);
   SetIndexBuffer(1,LowerBuffer);  SetIndexStyle(1,DRAW_ARROW); SetIndexArrow(1,159);
   SetIndexBuffer(2,UpperBuffer1); SetIndexStyle(2,DRAW_ARROW); SetIndexArrow(2,159);
   SetIndexBuffer(3,LowerBuffer1); SetIndexStyle(3,DRAW_ARROW); SetIndexArrow(3,159);
   SetIndexBuffer(4,UpperBuffer2); SetIndexStyle(4,DRAW_ARROW); SetIndexArrow(4,159);
   SetIndexBuffer(5,LowerBuffer2); SetIndexStyle(5,DRAW_ARROW); SetIndexArrow(5,159);
   SetIndexBuffer(6,UpperBuffer3); SetIndexStyle(6,DRAW_ARROW); SetIndexArrow(6,159);
   SetIndexBuffer(7,LowerBuffer3); SetIndexStyle(7,DRAW_ARROW); SetIndexArrow(7,159);
   if (MathMod(FractalPeriod,2)==0)
         FractalPeriod = FractalPeriod+1;
         indicatorFileName = WindowExpertName();
         returnBars        = (TimeFrame1=="returnBars");     if (returnBars)     return(0);
         calculateValue    = (TimeFrame1=="calculateValue"); if (calculateValue) return(0);
      timeFrames[0] = stringToTimeFrame(TimeFrame1);
      timeFrames[1] = stringToTimeFrame(TimeFrame2);
      timeFrames[2] = stringToTimeFrame(TimeFrame3);
      timeFrames[3] = stringToTimeFrame(TimeFrame4);
   return(0);      
}
int deinit() { return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit=MathMin(MathMax(Bars-counted_bars,FractalPeriod),Bars-1);
         if (returnBars) { UpperBuffer[0] = limit+1; return(0); }

   //
   //
   //
   //
   //

   if (calculateValue)
   {
      for(int i=limit; i>=0; i--)
      {
         int half = FractalPeriod/2;
         bool   found     = true;
         double compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i);
         for (int k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i+k)> compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i-k)>=compareTo) { found=false; break; }
            }
         if (found) 
               UpperBuffer[i]=High[i]+iATR(NULL,0,20,i)*UpperArrowDisplacement1;
         else  UpperBuffer[i]=EMPTY_VALUE;

         //
         //
         //
         //
         //
      
         found     = true;
         compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceLow,i);
         for (k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i+k)< compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i-k)<=compareTo) { found=false; break; }
            }
         if (found)
              LowerBuffer[i]=Low[i]-iATR(NULL,0,20,i)*LowerArrowDisplacement1;
         else LowerBuffer[i]=EMPTY_VALUE;
      }
      
      //
      //
      //
      //
      //
      
      if (alertsOn)
      {
         static datetime previousLevel = -1; static int previousSignal = 0;
         int currentBar=-1;
               for (i=0; i<Bars-1; i++) if (LowerBuffer[i]!=EMPTY_VALUE || UpperBuffer[i]!=EMPTY_VALUE) { currentBar = i; break; }
         if (currentBar>-1) checkAlert(currentBar,previousLevel,previousSignal,UpperBuffer,LowerBuffer ,"");
      }
      return(0);
   }      

   //
   //
   //
   //
   //
   
   if (timeFrames[0] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,"returnBars",0,0)*timeFrames[0]/Period()));
   if (timeFrames[1] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,"returnBars",0,0)*timeFrames[1]/Period()));
   if (timeFrames[2] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,"returnBars",0,0)*timeFrames[2]/Period()));
   if (timeFrames[3] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,"returnBars",0,0)*timeFrames[3]/Period()));
   for(i=limit; i>=0; i--)
   {
      for (k=0; k<4; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
         int x = iBarShift(NULL,timeFrames[k],Time[i+1]);
         if (x!=y)
         {
            switch (k)
            {
               case 0: 
                     UpperBuffer[i]  = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement1,LowerArrowDisplacement1,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     LowerBuffer[i]  = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement1,LowerArrowDisplacement1,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                     break;
               case 1: 
                     UpperBuffer1[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement2,LowerArrowDisplacement2,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     LowerBuffer1[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement2,LowerArrowDisplacement2,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                     break;
               case 2: 
                     UpperBuffer2[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement3,LowerArrowDisplacement3,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     LowerBuffer2[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement3,LowerArrowDisplacement3,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                     break;
               case 3: 
                     UpperBuffer3[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement4,LowerArrowDisplacement4,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     LowerBuffer3[i] = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,UpperArrowDisplacement4,LowerArrowDisplacement4,0,0,0,0,0,0,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                     break;
            }
         }
         else
         {
            switch (k)
            {
               case 0 : UpperBuffer[i]  = EMPTY_VALUE;  LowerBuffer[i]  = EMPTY_VALUE; break;
               case 1 : UpperBuffer1[i] = EMPTY_VALUE;  LowerBuffer1[i] = EMPTY_VALUE; break;
               case 2 : UpperBuffer2[i] = EMPTY_VALUE;  LowerBuffer2[i] = EMPTY_VALUE; break;
               case 3 : UpperBuffer3[i] = EMPTY_VALUE;  LowerBuffer3[i] = EMPTY_VALUE; break;
            }
         }
      }
   }            
   return(0);
}

//+------------------------------------------------------------------+
//|                                                             
//+------------------------------------------------------------------+
//
//
//
//
//

void checkAlert(int currentBar, datetime& previousLevel, int& previousSignal, double& upBuffer[], double& dnBuffer[], string text)
{
   int previousBar = iBarShift(NULL,0,previousLevel);
   int currentSignal;
         if (upBuffer[currentBar]!=EMPTY_VALUE)                                      currentSignal = -1;
         if (dnBuffer[currentBar]!=EMPTY_VALUE)                                      currentSignal =  1;
         if (dnBuffer[currentBar]!=EMPTY_VALUE && upBuffer[currentBar]!=EMPTY_VALUE) currentSignal =  0;

   //
   //
   //
   //
   //
   
   if (currentBar != previousBar || currentSignal != previousSignal)
   {
      if (currentSignal != previousSignal && currentBar > previousBar && previousLevel != -1)
            string alertText = "reverted to ";
      else         alertText = "current signal ";            
      switch(currentSignal)
      {
         case  0 : doAlert(text+alertText+"up/down"); break;
         case  1 : doAlert(text+alertText+"up");      break;
         case -1 : doAlert(text+alertText+"down");
      }               
 
      //
      //
      //
      //
      //
              
      previousLevel  = Time[currentBar];
      previousSignal = currentSignal;
   }
}

//
//
//
//
//

void doAlert(string doWhat)
{
   string message =  timeFrameToString(Period())+" "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" Fractals "+doWhat;
      if (alertsMessage) Alert(message);
      if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"Fractals"),message);
      if (alertsSound)   PlaySound("alert2.wav");
      if (alertsNotify)  SendNotification(message);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int toInt(double value) { return(value); }
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   int max = ArraySize(iTfTable)-1, add=0;
   int nxt = (StringFind(tfs,"NEXT1")>-1); if (nxt>0) { tfs = ""+Period(); add=1; }
       nxt = (StringFind(tfs,"NEXT2")>-1); if (nxt>0) { tfs = ""+Period(); add=2; }
       nxt = (StringFind(tfs,"NEXT3")>-1); if (nxt>0) { tfs = ""+Period(); add=3; }

      //
      //
      //
      //
      //
         
      for (int i=max; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[toInt(MathMin(max,i+add))],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}